/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.attribute;

import dev.toma.gunsrpg.api.common.attribute.IAttribute;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;

public class AttributeId
implements IAttributeId {
    private final ResourceLocation id;
    private final IAttribFactory factory;
    private final double baseValue;

    private AttributeId(ResourceLocation id, IAttribFactory factory, double baseValue) {
        this.id = id;
        this.factory = factory;
        this.baseValue = baseValue;
    }

    public static AttributeId create(ResourceLocation id, double base, IAttribFactory factory) {
        return new AttributeId(Objects.requireNonNull(id), Objects.requireNonNull(factory), base);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public IAttribute createNewInstance() {
        return this.factory.constructAttribute(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeId that = (AttributeId)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "AttributeId{id=" + this.id + '}';
    }

    public static interface IAttribFactory {
        public IAttribute constructAttribute(IAttributeId var1);
    }
}

